<?php
if(!defined('IN_DISCUZ')) exit('Access Denied');
class plugin_qianxi_threadhtml {
    private $config;
    private $currentTid;
    public function __construct() {
    }
    public function discuzcode($param) {
        global $_G;
        if($param['caller'] != 'discuzcode' || !in_array($_G['mod'], ['viewthread', 'forumdisplay'])) {
            return;
        }
        $this->config = $_G['cache']['plugin']['qianxi_threadhtml'];
        $this->currentTid = intval($_G['tid']);
        if(empty($this->config['kg']) || $this->config['kg'] != 1) return;
        $bindTid = intval($this->config['tz']);
        if($this->currentTid != $bindTid) return;
        $templateVars = $this->prepareTemplateVars();
        $newContent = $this->fetchTemplate($templateVars);
        $_G['discuzcodemessage'] = $newContent;
    }
    private function prepareTemplateVars() {
        $mainTitle = $this->config['biaoti'] ?? '';
        $mainTitleIcon = $this->config['biaotiico'] ?? '';
        $mainTitleBg = $this->config['biaotibj'] ?? '#f8f5ff';
        $floors = [];
        $floorLetters = ['a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j'];
        foreach($floorLetters as $letter) {
            if(empty($this->config[$letter])) continue;
            
            $floors[] = [
                'title' => $this->config[$letter],
                'icon' => $this->config[$letter . 'ico'] ?? '',
                'bg_color' => $this->config[$letter . 'bj'] ?? '#f8f5ff',
                'content' => $this->parseFloorContent($this->config[$letter . 'nr'] ?? '')
            ];
        }
        
        return [
            'main_title' => $mainTitle,
            'main_title_icon' => $mainTitleIcon,
            'main_title_bg' => $mainTitleBg,
            'floors' => $floors
        ];
    }
    private function parseFloorContent($content) {
        if(empty($content)) {
            return '<tr><td class="nav-cell">无内容</td></tr>';
        }
        $lines = explode("\n", $content);
        $cells = [];
        $rows = [];
        global $_G;
        
        foreach($lines as $line) {
            $line = trim($line);
            if(empty($line)) continue;
            
            $parts = explode('：', $line, 2);
            if(count($parts) < 2) $parts = explode(':', $line, 2);
            
            if(count($parts) == 2) {
                $text = trim($parts[0]);
                $url = trim($parts[1]);
                if(strpos($url, 'http') === false) $url = $_G['siteurl'] . $url;
                $cells[] = "<td class='nav-cell'><a href='{$url}' class='nav-link'><b><font size='3'>{$text}</font></b></a></td>";
            } else {
                $cells[] = "<td class='nav-cell'><span class='nav-link'><b><font size='3'>{$line}</font></b></span></td>";
            }
            
            if(count($cells) >= 5) {
                $rows[] = '<tr>' . implode('', $cells) . '</tr>';
                $cells = [];
            }
        }
        
        if(!empty($cells)) {
            $remaining = 5 - count($cells);
            for($i = 0; $i < $remaining; $i++) {
                $cells[] = '<td class="nav-cell"></td>';
            }
            $rows[] = '<tr>' . implode('', $cells) . '</tr>';
        }
        
        return implode('', $rows);
    }
    private function fetchTemplate($vars) {
        loadcache('plugin');
        global $_G;
        extract($vars);
        ob_start();
        include template('qianxi_threadhtml:threadhtml');
        $html =  ob_get_clean();
        foreach($vars as $key => $value) {
            unset($_G['template_vars'][$key]);
        }
        $html = preg_replace('/\s+/', ' ', $html);
        $html = str_replace('> <', '><', $html);
        
        return $html;
    }
}
class plugin_qianxi_threadhtml_forum extends plugin_qianxi_threadhtml {
    
}
